#!/bin/sh
# Convert Tom Pittman's "A Short Course in Programming" to epub & pdf
# scruss, 2025-10
# requires curl and ebook-convert (from Calibre)

text_url='http://www.ittybittycomputers.com/IttyBitty/ShortCor.htm'
img_url='https://upload.wikimedia.org/wikipedia/commons/thumb/3/3e/ElF_II_Computer.jpg/640px-ElF_II_Computer.jpg'
img_attrib='<p>Cover image by John crane 59 - Own work, CC BY-SA 3.0, <a href="https://commons.wikimedia.org/w/index.php?curid=15795865">File:ElF II Computer.jpg - Wikimedia Commons</a></p>'

# who knew that basename works with urls?
text_file=$(basename "$text_url")
img_file=$(basename "$img_url")
epub_file='TomPittman-A_Short_Course_in_Programming.epub'
pdf_file="$(basename ${epub_file} '.epub').pdf"

# download html from Tom's site, add link, give cover attrib and fix typo
curl "$text_url" |\
    sed "s,Tom Pittman,<a href=\"$text_url\">&</a>," |\
    sed "s|</body>|$img_attrib&|" |\
    sed 's/2E80/2E82/;' > "$text_file"

# download cover from Wikimedia Commons
curl -o "$img_file" "$img_url"

# make epub
if
    [ -f "$text_file" ]
then
    if
	[ -f "$img_file" ]
    then
	ebook-convert "$text_file" \
		      "$epub_file" \
		      --cover "$img_file" \
		      --preserve-cover-aspect-ratio \
		      --title "A Short Course In Programming" \
		      --authors "Tom Pittman" \
		      --language en \
		      --pubdate 1980 \
		      --tags "programming, cosmac, elf, rca, cdp1802, 1802, machine_code, binary, hexadecimal, netronics" \
		      --comments "A Short Course in Programming the RCA COSMAC CDP1802 Microprocessor using the Netronics ELF II (Tom Pittman, 1980)" \
		      && rm "$text_file" "$img_file"
    fi
    
fi

# make pdf from epub - avoids problems making PDF directly
# (I think it's in the original markup where things go sideways)
if
    [ -f "$epub_file" ]
then
    ebook-convert "$epub_file" \
		  "$pdf_file" \
		  --preserve-cover-aspect-ratio \
		  --paper-size letter --pdf-add-toc --pdf-page-numbers \
		  --pdf-mono-font-size 14 --pdf-page-margin-left 36 \
		  --pdf-page-margin-right 36
fi

# done
echo ""
echo "Created:"
ls "$epub_file" "$pdf_file"
